/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.thema;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.LocalSemanticDatabase;
import data.structures.tagging.LemmaItem;
import data.structures.corpus.CorpusGraph;

import java.util.LinkedHashSet;
import java.util.Set;

public class OntologyLinker {

    private Database myDB;
    //private ArrayList ontologies;
    //private Requests rq;
    private LocalSemanticDatabase lrq;

    public OntologyLinker(Database db) {
        myDB = db;
        //rq = new Requests(myDB);
        lrq = new LocalSemanticDatabase(myDB);
        //ontologies = rq.getlowerLevels();
        //System.out.println("ontology lower levels : "+ontologies.size());
    }

    /*public void process() {
        //test avec sarlozy et l'otan
        int[] RSS = {51};
        Set<Graph_item> rssGraphItems = getRSSItemsGraph(RSS);
        Iterator iter_rss = rssGraphItems.iterator();

        while (iter_rss.hasNext()) {
            Graph_item myItem = (Graph_item) iter_rss.next();
            Set<String> myLemmas = getQueryLemmas(myItem);
            Iterator iter_lemmas = myLemmas.iterator();
            while (iter_lemmas.hasNext()) {
                String myLemma = (String) iter_lemmas.next();
                System.out.println(myLemma);
//                Hashtable<String,String> candidates = sparqlRequests(myLemma);
//                    getBestRessource(candidates);
            }
        }
    }*/

    /**
     * Calcule les thématiques rattachées au corpus d'étude
     * @return les thématiques rattachées au corpus d'étude
     */
    /*public String[] processCorpus() {
        currentState = 0;
        Graph_item[] corpusGraphItems = getCorpusGraph().getItems();
        String[] thematiques = new String[corpusGraphItems.length];
        for(int i=0; i<corpusGraphItems.length; i++){
            String[] lemmes = corpusGraphItems[i].getLemmasAsStrings();
            for(int j=0; j<lemmes.length; j++){
                Hashtable<String,String> candidates = sparqlRequests(lemmes[i]);
                thematiques[i] = thematiques[i]+" "+getBestRessource(candidates);
                System.out.println("Thématique trouvée : "+thematiques[i]);
            }
            currentState++;
        }
        return thematiques;
    }
    private int currentState = 0;
    public int getCurrentState(){
        return currentState;
    }*/

    /*private Set<String> getQueryLemmas(Graph_item depeche) {
        ArrayList namLemmas = new ArrayList();
        Set<Lemma_item> myTaggedLemmas = new LinkedHashSet<Lemma_item>();
        Set<String> result = new LinkedHashSet<String>();
        RSS_item myRSSItem = getRSSItem(depeche.getNodeID());
        String[] allLemmas = (myRSSItem.getTitleLemmes() + "" + myRSSItem.getDescLemmes()).split(" ");
        //les lemmes taggés
        myTaggedLemmas = depeche.getLemmas();

        Iterator iter_tag = myTaggedLemmas.iterator();
        while (iter_tag.hasNext()) {
            Lemma_item myLemma = (Lemma_item) iter_tag.next();
            if (myLemma.getLemmaLex().equalsIgnoreCase("NAM")) {
                namLemmas.add(myLemma.getLemmaName());
            }
        }
        String lemma = new String();
        for (int i = 0; i < allLemmas.length; i++) {
            if (namLemmas.contains(allLemmas[i])) {
                lemma = lemma + " " + allLemmas[i];
            } else {
                result.add(lemma);
                lemma = "";
            }
        }
        return result;
    }*/

    /*private LinkedHashSet<Graph_item> getRSSItemsGraph(int[] myItems) {
        LinkedHashSet<Graph_item> rssGraphItems = new LinkedHashSet<Graph_item>();
        for (int i = 0; i < myItems.length; i++) {
            RSS_graph myGraph = new RSS_graph(myDB);
            myGraph.setNode(myItems[i]);
            Graph_item node = myGraph.getNode();
            rssGraphItems.add(node);
        }
        return rssGraphItems;
    }*/

    private CorpusGraph getCorpusGraph() {
        return new CorpusGraph(myDB);
    }

    /*private RSS_item getRSSItem(int id) {
        RSS_item myItem = new RSS_item();
        RSSFeedDatabase rss_db = new RSSFeedDatabase(myDB);
        myItem = rss_db.getRssItem(id);
        return myItem;
    }*/

    /*private Hashtable<String, String> sparqlRequests(String lemma) {
        Hashtable<String, String> candidates = new Hashtable<String, String>();
        ArrayList result = new ArrayList();
        for (int i = 0; i < ontologies.size(); i++) {
            result = rq.getCandidatesURI(lemma, ontologies.get(i).toString());
            for (int z = 0; z < result.size(); z++) {
                candidates.put(result.get(z).toString(), ontologies.get(i).toString());
            }
        }
        return candidates;
    }*/

    /*private String getBestRessource(Hashtable<String, String> candidates) {
        String result = new String();
        Vector<String> v = new Vector<String>(candidates.keySet());
        Vector<String> v2 = new Vector<String>(candidates.values());
        System.out.println("clefs : " + v);
        System.out.println("valeurs : " + v2);
        return result;
    }*/

    public Set<String> getGeneralisation(Set<LemmaItem> lemmas, int steps) throws NoBaseException {
        LemmaItem[] liste = new LemmaItem[lemmas.size()];
        lemmas.toArray(liste);
        Set<String> resultat = new LinkedHashSet<String>();
        for(int i=0; i<liste.length; i++){
            String nom = liste[i].getLemmaName();
            String[] newLemmes = lrq.getGeneralisationStricte(nom, steps);
            for (int k = 0; k < newLemmes.length; k++) {
                resultat.add(newLemmes[k]);
            }
            /*for(int j=0; j<steps; j++){
                //Envoyer une requête SPARQL pour trouver la catégorie plus
                //générale de ce lemme, s'il est dedans.
                nom = rq.getCategorie(nom);
                //On oublie si la catégorie récupérée est vide.
                if(nom == null){
                    break;
                }
                if(nom.equalsIgnoreCase("")){
                    break;
                }
                //Rajouter le lemme catégorie à la liste de lemmes.
                Lemma_item newLemme = new Lemma_item();
                newLemme.setLemmaName(nom);
                newLemme.setCountDesc(1);
                newLemme.setCountTitle(0);
                lemmas.add(newLemme);
            }*/
        }
        return resultat;
    }
}
